<?php

namespace App\Http\Controllers;

use App\Admin;
use App\AdminWallet;
use App\CustomPush;
use App\Fleet;
use App\Helpers\Helper;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProviderResources\TripController;
use App\Http\Controllers\SendPushNotification;
use App\Provider;
use App\ProviderDocument;
use App\ProviderService;
use App\ServiceType;
use App\User;
use App\UserRequestPayment;
use App\UserRequestRating;
use App\UserRequests;
use App\WalletRequests;
use Auth;
use DB;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;
use Session;
use Setting;
use ZipArchive;
use \Carbon\Carbon;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // dd('eaa');
        $this->middleware(['combo']);
        // $this->middleware('admin');
        $this->middleware('demo', ['only' => [
            'settings_store',
            'settings_payment_store',
            'profile_update',
            'password_update',
            'send_push',
        ]]);
        $this->perpage = Setting::get('per_page', '10');
    }

    /**
     * Dashboard.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function dashboard()
    {
        try {

            Session::put('user', Auth::User());

            /*$UserRequest = UserRequests::with('service_type')->with('provider')->with('payment')->findOrFail(83);

            echo "<pre>";
            print_r($UserRequest->toArray());exit;

            return view('emails.invoice',['Email' => $UserRequest]);*/

            $rides = UserRequests::has('user')->orderBy('id', 'desc')->get();
            $cancel_rides = UserRequests::where('status', 'CANCELLED');
            $scheduled_rides = UserRequests::where('status', 'SCHEDULED')->count();
            $user_cancelled = UserRequests::where('status', 'CANCELLED')->where('cancelled_by', 'USER')->count();
            $provider_cancelled = UserRequests::where('status', 'CANCELLED')->where('cancelled_by', 'PROVIDER')->count();
            $cancel_rides = $cancel_rides->count();
            $service = ServiceType::count();
            $fleet = Fleet::count();
            $provider = Provider::count();
            $revenue = UserRequestPayment::sum('flat_rate');
            $wallet['tips'] = UserRequestPayment::sum('tips');
            $providers = Provider::take(10)->orderBy('rating', 'desc')->get();
            $wallet['admin'] = AdminWallet::sum('amount');
            $wallet['provider_debit'] = Provider::select(DB::raw('SUM(CASE WHEN wallet_balance<0 THEN wallet_balance ELSE 0 END) as total_debit'))->get()->toArray();
            $wallet['provider_credit'] = Provider::select(DB::raw('SUM(CASE WHEN wallet_balance>=0 THEN wallet_balance ELSE 0 END) as total_credit'))->get()->toArray();
            $wallet['fleet_debit'] = Fleet::select(DB::raw('SUM(CASE WHEN wallet_balance<0 THEN wallet_balance ELSE 0 END) as total_debit'))->get()->toArray();
            $wallet['fleet_credit'] = Fleet::select(DB::raw('SUM(CASE WHEN wallet_balance>=0 THEN wallet_balance ELSE 0 END) as total_credit'))->get()->toArray();

            $wallet['admin_tax'] = AdminWallet::where('transaction_type', 9)->sum('amount');
            $wallet['admin_commission'] = AdminWallet::where('transaction_type', 1)->sum('amount');
            $wallet['admin_discount'] = AdminWallet::where('transaction_type', 10)->sum('amount');

            return view('admin.dashboard', compact('providers', 'fleet', 'provider', 'scheduled_rides', 'service', 'rides', 'user_cancelled', 'provider_cancelled', 'cancel_rides', 'revenue', 'wallet'));
        } catch (Exception $e) {
            return redirect()->route('admin.user.index')->with('flash_error', 'Something Went Wrong with Dashboard!');
        }
    }

    /**
     * Heat Map.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function heatmap()
    {
        try {
            $rides = UserRequests::has('user')->orderBy('id', 'desc')->get();
            $providers = Provider::take(10)->orderBy('rating', 'desc')->get();
            return view('admin.heatmap', compact('providers', 'rides'));
        } catch (Exception $e) {
            return redirect()->route('admin.user.index')->with('flash_error', 'Something Went Wrong with Dashboard!');
        }
    }


    public function map_index()
    {
        return view('admin.map.index');
    }

    public function map_ajax()
    {
        try {

            $Providers = Provider::where('latitude', '!=', 0)
                ->where('longitude', '!=', 0)
                ->with('service')
                ->get();

            $Users = User::where('latitude', '!=', 0)
                ->where('longitude', '!=', 0)
                ->get();

            for ($i = 0; $i < sizeof($Users); $i++) {
                $Users[$i]->status = 'user';
            }

            $All = $Users->merge($Providers);

            return $All;

        } catch (Exception $e) {
            return [];
        }
    }


    public function settings()
    {
        return view('admin.settings.application');
    }

    public function settings_store(Request $request)
    {

        $this->validate($request, [
            'site_title' => 'required',
            'site_icon' => 'mimes:jpeg,jpg,bmp,png|max:5242880',
            'site_logo' => 'mimes:jpeg,jpg,bmp,png|max:5242880',
        ]);

        if ($request->hasFile('site_icon')) {
            $site_icon = Helper::upload_picture($request->file('site_icon'));
            Setting::set('site_icon', $site_icon);
        }

        if ($request->hasFile('site_logo')) {
            $site_logo = Helper::upload_picture($request->file('site_logo'));
            Setting::set('site_logo', $site_logo);
        }

        if ($request->hasFile('site_email_logo')) {
            $site_email_logo = Helper::upload_picture($request->file('site_email_logo'));
            Setting::set('site_email_logo', $site_email_logo);
        }

        Setting::set('site_title', $request->site_title);
        Setting::set('store_link_android_user', $request->store_link_android_user);
        Setting::set('version_android_user', $request->version_android_user);
        Setting::set('store_link_android_provider', $request->store_link_android_provider);
        Setting::set('version_android_provider', $request->version_android_provider);
        Setting::set('store_link_ios_user', $request->store_link_ios_user);
        Setting::set('version_ios_user', $request->version_ios_user);
        Setting::set('store_link_ios_provider', $request->store_link_ios_provider);
        Setting::set('version_ios_provider', $request->version_ios_provider);
        Setting::set('store_facebook_link', $request->store_facebook_link);
        Setting::set('store_twitter_link', $request->store_twitter_link);
        Setting::set('provider_select_timeout', $request->provider_select_timeout);
        Setting::set('provider_search_radius', $request->provider_search_radius);
        Setting::set('sos_number', $request->sos_number);
        Setting::set('contact_number', $request->contact_number);
        Setting::set('contact_email', $request->contact_email);
        Setting::set('contact_address', $request->contact_address);
        Setting::set('site_copyright', $request->site_copyright);
        Setting::set('social_login', $request->social_login);
        Setting::set('map_key', $request->map_key);
        Setting::set('fb_app_version', $request->fb_app_version);
        Setting::set('fb_app_id', $request->fb_app_id);
        Setting::set('fb_app_secret', $request->fb_app_secret);
        Setting::set('manual_request', $request->manual_request == 'on' ? 1 : 0);
        Setting::set('broadcast_request', $request->broadcast_request == 'on' ? 1 : 0);
        Setting::set('track_distance', $request->track_distance == 'on' ? 1 : 0);
        Setting::set('distance', $request->distance);
        Setting::save();

        return back()->with('flash_success', 'Settings Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function settings_payment()
    {
        return view('admin.payment.settings');
    }

    /**
     * Save payment related settings.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function settings_payment_store(Request $request)
    {

        $this->validate($request, [
            'CARD' => 'in:on',
            'CASH' => 'in:on',
            'ELAVON' => 'in:on',

            'elavon_merchant_id' => 'required_if:ELAVON,on|max:255',
            'elavon_user_id' => 'required_if:ELAVON,on|max:255',
            'elavon_pin' => 'required_if:ELAVON,on|max:255',

            'stripe_secret_key' => 'required_if:CARD,on|max:255',
            'stripe_publishable_key' => 'required_if:CARD,on|max:255',
            'daily_target' => 'required|integer|min:0',
            'tax_percentage' => 'required|numeric|min:0|max:100',
            'surge_percentage' => 'required|numeric|min:0|max:100',
            'commission_percentage' => 'required|numeric|min:0|max:100',
            'fleet_commission_percentage' => 'sometimes|nullable|numeric|min:0|max:100',
            'surge_trigger' => 'required|integer|min:0',
            'currency' => 'required',
            'user_negative_wallet_limit' => 'required',
            'ride_cancellation_minutes' => 'required',
        ]);

        if ($request->has('CARD') == 0 && $request->has('CASH') == 0) {
            return back()->with('flash_error', 'Atleast one payment mode must be enable.');
        }

        Setting::set('CARD', $request->has('CARD') ? 1 : 0);
        Setting::set('CASH', $request->has('CASH') ? 1 : 0);
        Setting::set('stripe_secret_key', $request->stripe_secret_key);
        Setting::set('stripe_publishable_key', $request->stripe_publishable_key);

        /*Setting::set('ELAVON', $request->has('ELAVON') ? 1 : 0 );
        Setting::set('elavon_merchant_id', $request->elavon_merchant_id );
        Setting::set('elavon_user_id', $request->elavon_user_id);
        Setting::set('elavon_pin', $request->elavon_pin);
        Setting::set('elavon_mode', $request->elavon_mode);
         */

        //Setting::set('stripe_oauth_url', $request->stripe_oauth_url);
        Setting::set('daily_target', $request->daily_target);
        Setting::set('tax_percentage', $request->tax_percentage);
        Setting::set('surge_percentage', $request->surge_percentage);
        Setting::set('commission_percentage', $request->commission_percentage);
        Setting::set('provider_commission_percentage', 0);
        Setting::set('fleet_commission_percentage', $request->has('fleet_commission_percentage') ? $request->fleet_commission_percentage : 0);
        Setting::set('surge_trigger', $request->surge_trigger);
        Setting::set('currency', $request->currency);
        Setting::set('booking_prefix', $request->booking_prefix);
        Setting::set('user_negative_wallet_limit', $request->user_negative_wallet_limit);
        Setting::set('ride_cancellation_minutes', $request->ride_cancellation_minutes);

        Setting::save();

        return back()->with('flash_success', 'Settings Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function profile()
    {
        return view('admin.account.profile');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function profile_update(Request $request)
    {

        $this->validate($request, [
            'name' => 'required|max:255',
            'email' => 'required|max:255|email|unique:admins,email,' . Auth::guard('admin')->user()->id . ',id',
            'picture' => 'mimes:jpeg,jpg,bmp,png|max:5242880',
        ]);

        try {
            $admin = Auth::guard('admin')->user();
            $admin->name = $request->name;
            $admin->email = $request->email;
            $admin->language = $request->language;

            if ($request->hasFile('picture')) {
                $admin->picture = $request->picture->store('admin/profile');
            }
            $admin->save();

            Session::put('user', Auth::User());

            return redirect()->back()->with('flash_success', 'Profile Updated');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function password()
    {
        return view('admin.account.change-password');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function password_update(Request $request)
    {

        $this->validate($request, [
            'old_password' => 'required',
            'password' => 'required|min:6|confirmed',
        ]);

        try {

            $Admin = Admin::find(Auth::guard('admin')->user()->id);

            if (password_verify($request->old_password, $Admin->password)) {
                $Admin->password = bcrypt($request->password);
                $Admin->save();

                return redirect()->back()->with('flash_success', 'Password Updated');
            }
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function payment()
    {
        try {
            $payments = UserRequests::where('paid', 1)
                ->has('user')
                ->has('provider')
                ->has('payment')
                ->orderBy('user_requests.created_at', 'desc')
                ->paginate($this->perpage);

            $pagination = (new Helper)->formatPagination($payments);

            return view('admin.payment.payment-history', compact('payments', 'pagination'));
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function help()
    {
        try {
            $str = file_get_contents('http://appoets.com/help.json');
            $Data = json_decode($str, true);
            return view('admin.help', compact('Data'));
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * User Rating.
     *
     * @return \Illuminate\Http\Response
     */
    public function user_review()
    {
        try {
            $Reviews = UserRequestRating::where('user_id', '!=', 0)->with('user', 'provider')->paginate($this->perpage);
            $pagination = (new Helper)->formatPagination($Reviews);
            return view('admin.review.user_review', compact('Reviews', 'pagination'));

        } catch (Exception $e) {
            return redirect()->route('admin.setting')->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * Provider Rating.
     *
     * @return \Illuminate\Http\Response
     */
    public function provider_review()
    {
        try {
            $Reviews = UserRequestRating::where('provider_id', '!=', 0)->with('user', 'provider')->paginate($this->perpage);
            $pagination = (new Helper)->formatPagination($Reviews);
            return view('admin.review.provider_review', compact('Reviews', 'pagination'));
        } catch (Exception $e) {
            return redirect()->route('admin.setting')->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProviderService
     * @return \Illuminate\Http\Response
     */
    public function destory_provider_service($id)
    {
        try {
            ProviderService::find($id)->delete();
            return back()->with('message', 'Service deleted successfully');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * Testing page for push notifications.
     *
     * @return \Illuminate\Http\Response
     */
    public function push_index()
    {

        $data = \PushNotification::app('IOSUser')
            ->to('3911e9870e7c42566b032266916db1f6af3af1d78da0b52ab230e81d38541afa')
            ->send('Hello World, i`m a push message');
        dd($data);
    }

    /**
     * Testing page for push notifications.
     *
     * @return \Illuminate\Http\Response
     */
    public function push_store(Request $request)
    {
        try {
            ProviderService::find($id)->delete();
            return back()->with('message', 'Service deleted successfully');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * privacy.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */

    public function cmspages()
    {
        return view('admin.pages.static');
    }

    /**
     * pages.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function pages(Request $request)
    {
        $this->validate($request, [
            'types' => 'required|not_in:select',
        ]);

        Setting::set($request->types, $request['content']);
        Setting::save();

        return back()->with('flash_success', 'Content Updated!');
    }

    public function pagesearch($request)
    {
        $value = Setting::get($request);
        return $value;
    }

    /**
     * account statements.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function statement($type = 'default', $request = null)
    {
        try {
            $page = trans('admin.include.overall_ride_statments');
            $listname = trans('admin.include.overall_ride_earnings');
            if ($type == 'individual') {
                $page = trans('admin.include.provider_statement');
                $listname = trans('admin.include.provider_earnings');
            } elseif ($type == 'today') {
                $page = trans('admin.include.today_statement') . ' - ' . date('d M Y');
                $listname = trans('admin.include.today_earnings');
            } elseif ($type == 'monthly') {
                $page = trans('admin.include.monthly_statement') . ' - ' . date('F');
                $listname = trans('admin.include.monthly_earnings');
            } elseif ($type == 'yearly') {
                $page = trans('admin.include.yearly_statement') . ' - ' . date('Y');
                $listname = trans('admin.include.yearly_earnings');
            } elseif ($type == 'range') {
                $page = trans('admin.include.statement_from') . ' ' .
                    Carbon::createFromFormat('Y-m-d', $request->from_date)->format('d M Y') . '  ' .
                    trans('admin.include.statement_to') . ' ' .
                    Carbon::createFromFormat('Y-m-d', $request->to_date)->format('d M Y');
            }
            $rides = UserRequests::with('payment', 'user')->orderBy('id', 'desc');
            $cancel_rides = UserRequests::where('status', 'CANCELLED');
            $revenue = UserRequestPayment::select(\DB::raw(
                'SUM(ROUND(fixed) + ROUND(distance)) as overall, SUM(ROUND(commision)) as commission'
            ));
            $period = '';
            if ($type == 'today') {
                $period = Carbon::today();
                //$rides->where('created_at', '>=', Carbon::today());
                //$cancel_rides->where('created_at', '>=', Carbon::today());
                //$revenue->where('created_at', '>=', Carbon::today());

            } elseif ($type == 'monthly') {
                $period = Carbon::now()->month;

                //$rides->where('created_at', '>=', Carbon::now()->month);
                //$cancel_rides->where('created_at', '>=', Carbon::now()->month);
                //$revenue->where('created_at', '>=', Carbon::now()->month);

            } elseif ($type == 'yearly') {
                $period = Carbon::now()->year;
                //$rides->where('created_at', '>=', Carbon::now()->year);
                //$cancel_rides->where('created_at', '>=', Carbon::now()->year);
                //$revenue->where('created_at', '>=', Carbon::now()->year);

            } elseif ($type == 'range') {

                if ($request->has('last-name') || $request->has('mobile-no') || $request->has('cab-no')) {
                    $rides = $this->prepareFilterQuery('default',$rides, $request);
                    $cancel_rides = $this->prepareFilterQuery('default',$cancel_rides, $request);
                    $revenue = $this->prepareFilterQuery('revenue',$revenue, $request);
                }

                if ($request->from_date == $request->to_date) {
                    if (isset($request->providerId)){
                        $rides->whereDate('created_at', date('Y-m-d', strtotime($request->from_date)))->where('provider_id',$request->providerId);
                        $cancel_rides->whereDate('created_at', date('Y-m-d', strtotime($request->from_date)))->where('provider_id',$request->providerId);
                        $revenue->whereDate('created_at', date('Y-m-d', strtotime($request->from_date)))->where('provider_id',$request->providerId);
                    }else{
                        $rides->whereDate('created_at', date('Y-m-d', strtotime($request->from_date)));
                        $cancel_rides->whereDate('created_at', date('Y-m-d', strtotime($request->from_date)));
                        $revenue->whereDate('created_at', date('Y-m-d', strtotime($request->from_date)));
                    }
                } else {
                    if (isset($request->providerId)){
                        $rides->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)])->where('provider_id',$request->providerId);
                        $cancel_rides->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)])->where('provider_id',$request->providerId);
                        $revenue->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)])->where('provider_id',$request->providerId);
                    }else{
                        $rides->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)]);
                        $cancel_rides->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)]);
                        $revenue->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)]);
                    }
                }
            }
            if (in_array($type, ['today', 'monthly', 'yearly'])) {
                $rides->where('created_at', '>=', $period);
                $cancel_rides->where('created_at', '>=', $period);
                $revenue->where('created_at', '>=', $period);
            }
            $rides = $rides->paginate($this->perpage);
            if ($type == 'range') {
                $rides->setPath($request->fullUrl());
            }
            $pagination = (new Helper)->formatPagination($rides);
            $cancel_rides = $cancel_rides->count();
            $revenue = $revenue->get();
            request()->flash();
            if ($request and $request->has('providerId')){
                $providerId = $request->get('providerId');
                return view('admin.providers.statement', compact('rides', 'cancel_rides', 'revenue', 'pagination', 'type','providerId'))
                    ->with('page', $page)->with('listname', $listname);
            }else{
                return view('admin.providers.statement', compact('rides', 'cancel_rides', 'revenue', 'pagination', 'type'))
                    ->with('page', $page)->with('listname', $listname);
            }


        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    private function prepareFilterQuery($type='default',$model, $request)
    {
        $model = $model->whereHas('user', function ($query) use ($request) {
            if ($request->has('last-name')) {
                $query->where('last_name', 'like', '%' . $request['last-name'] . '%');
            }
            if ($request->has('mobile-no')) {
                $query->where('mobile', 'like', '%' . $request['mobile-no'] . '%');
            }
        });
        if ($request->has('cab-no') && $type === 'default') {
            $model = $model->whereHas('provider_service', function($r) use ($request){
                return $r->where('service_number',$request['cab-no']);
            });
        }
        return $model;
    }

    /**
     * account statements today.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function statement_today()
    {
        return $this->statement('today');
    }

    /**
     * account statements monthly.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function statement_monthly()
    {
        return $this->statement('monthly');
    }

    /**
     * account statements monthly.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function statement_yearly()
    {
        return $this->statement('yearly');
    }

    /**
     * account statements range.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function statement_range(Request $request)
    {
        return $this->statement('range', $request);
    }

    /**
     * account statements.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function statement_provider()
    {

        try {

            $Providers = Provider::paginate($this->perpage);

            $pagination = (new Helper)->formatPagination($Providers);

            foreach ($Providers as $index => $Provider) {

                $Rides = UserRequests::where('provider_id', $Provider->id)
                    ->where('status', '<>', 'CANCELLED')
                    ->get()->pluck('id');

                $Providers[$index]->rides_count = $Rides->count();

                $Providers[$index]->payment = UserRequestPayment::whereIn('request_id', $Rides)
                    ->select(\DB::raw(
                        'SUM(ROUND(provider_pay)) as overall, SUM(ROUND(provider_commission)) as commission'
                    ))->get();

            }

            return view('admin.providers.provider-statement', compact('Providers', 'pagination'))->with('page', 'Providers Statement');

        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function translation()
    {

        try {
            return view('admin.translation');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function push()
    {

        try {
            $Pushes = CustomPush::orderBy('id', 'desc')->get();
            return view('admin.push', compact('Pushes'));
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    /**
     * pages.
     *
     * @param  \App\Provider  $provider
     * @return \Illuminate\Http\Response
     */
    public function send_push(Request $request)
    {

        $this->validate($request, [
            'send_to' => 'required|in:ALL,USERS,PROVIDERS',
            'user_condition' => ['required_if:send_to,USERS', 'in:ACTIVE,LOCATION,RIDES,AMOUNT'],
            'provider_condition' => ['required_if:send_to,PROVIDERS', 'in:ACTIVE,LOCATION,RIDES,AMOUNT'],
            'user_active' => ['required_if:user_condition,ACTIVE', 'in:HOUR,WEEK,MONTH'],
            'user_rides' => 'required_if:user_condition,RIDES',
            'user_location' => 'required_if:user_condition,LOCATION',
            'user_amount' => 'required_if:user_condition,AMOUNT',
            'provider_active' => ['required_if:provider_condition,ACTIVE', 'in:HOUR,WEEK,MONTH'],
            'provider_rides' => 'required_if:provider_condition,RIDES',
            'provider_location' => 'required_if:provider_condition,LOCATION',
            'provider_amount' => 'required_if:provider_condition,AMOUNT',
            'message' => 'required|max:100',
        ]);

        try {

            $CustomPush = new CustomPush;
            $CustomPush->send_to = $request->send_to;
            $CustomPush->message = $request->message;

            if ($request->send_to == 'USERS') {

                $CustomPush->condition = $request->user_condition;

                if ($request->user_condition == 'ACTIVE') {
                    $CustomPush->condition_data = $request->user_active;
                } elseif ($request->user_condition == 'LOCATION') {
                    $CustomPush->condition_data = $request->user_location;
                } elseif ($request->user_condition == 'RIDES') {
                    $CustomPush->condition_data = $request->user_rides;
                } elseif ($request->user_condition == 'AMOUNT') {
                    $CustomPush->condition_data = $request->user_amount;
                }

            } elseif ($request->send_to == 'PROVIDERS') {

                $CustomPush->condition = $request->provider_condition;

                if ($request->provider_condition == 'ACTIVE') {
                    $CustomPush->condition_data = $request->provider_active;
                } elseif ($request->provider_condition == 'LOCATION') {
                    $CustomPush->condition_data = $request->provider_location;
                } elseif ($request->provider_condition == 'RIDES') {
                    $CustomPush->condition_data = $request->provider_rides;
                } elseif ($request->provider_condition == 'AMOUNT') {
                    $CustomPush->condition_data = $request->provider_amount;
                }
            }

            if ($request->has('schedule_date') && $request->has('schedule_time')) {
                $CustomPush->schedule_at = date("Y-m-d H:i:s", strtotime("$request->schedule_date $request->schedule_time"));
            }

            $CustomPush->save();

            if ($CustomPush->schedule_at == '') {
                $this->SendCustomPush($CustomPush->id);
            }

            return back()->with('flash_success', 'Message Sent to all ' . $request->segment);
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    public function SendCustomPush($CustomPush)
    {

        try {

            \Log::notice("Starting Custom Push");

            $Push = CustomPush::findOrFail($CustomPush);

            if ($Push->send_to == 'USERS') {

                $Users = [];

                if ($Push->condition == 'ACTIVE') {

                    if ($Push->condition_data == 'HOUR') {

                        $Users = User::whereHas('trips', function ($query) {
                            $query->where('created_at', '>=', Carbon::now()->subHour());
                        })->get();

                    } elseif ($Push->condition_data == 'WEEK') {

                        $Users = User::whereHas('trips', function ($query) {
                            $query->where('created_at', '>=', Carbon::now()->subWeek());
                        })->get();

                    } elseif ($Push->condition_data == 'MONTH') {

                        $Users = User::whereHas('trips', function ($query) {
                            $query->where('created_at', '>=', Carbon::now()->subMonth());
                        })->get();

                    }

                } elseif ($Push->condition == 'RIDES') {

                    $Users = User::whereHas('trips', function ($query) use ($Push) {
                        $query->where('status', 'COMPLETED');
                        $query->groupBy('id');
                        $query->havingRaw('COUNT(*) >= ' . $Push->condition_data);
                    })->get();

                } elseif ($Push->condition == 'LOCATION') {

                    $Location = explode(',', $Push->condition_data);

                    $distance = Setting::get('provider_search_radius', '10');
                    $latitude = $Location[0];
                    $longitude = $Location[1];

                    $Users = User::whereRaw("(1.609344 * 3956 * acos( cos( radians('$latitude') ) * cos( radians(latitude) ) * cos( radians(longitude) - radians('$longitude') ) + sin( radians('$latitude') ) * sin( radians(latitude) ) ) ) <= $distance")
                        ->get();

                }

                $type = 0;
                foreach ($Users as $key => $user) {
                    (new SendPushNotification)->sendPushToUser($user->id, $Push->message, $type);
                }

            } elseif ($Push->send_to == 'PROVIDERS') {

                $Providers = [];

                if ($Push->condition == 'ACTIVE') {

                    if ($Push->condition_data == 'HOUR') {

                        $Providers = Provider::whereHas('trips', function ($query) {
                            $query->where('created_at', '>=', Carbon::now()->subHour());
                        })->get();

                    } elseif ($Push->condition_data == 'WEEK') {

                        $Providers = Provider::whereHas('trips', function ($query) {
                            $query->where('created_at', '>=', Carbon::now()->subWeek());
                        })->get();

                    } elseif ($Push->condition_data == 'MONTH') {

                        $Providers = Provider::whereHas('trips', function ($query) {
                            $query->where('created_at', '>=', Carbon::now()->subMonth());
                        })->get();

                    }

                } elseif ($Push->condition == 'RIDES') {

                    $Providers = Provider::whereHas('trips', function ($query) use ($Push) {
                        $query->where('status', 'COMPLETED');
                        $query->groupBy('id');
                        $query->havingRaw('COUNT(*) >= ' . $Push->condition_data);
                    })->get();

                } elseif ($Push->condition == 'LOCATION') {

                    $Location = explode(',', $Push->condition_data);

                    $distance = Setting::get('provider_search_radius', '10');
                    $latitude = $Location[0];
                    $longitude = $Location[1];

                    $Providers = Provider::whereRaw("(1.609344 * 3956 * acos( cos( radians('$latitude') ) * cos( radians(latitude) ) * cos( radians(longitude) - radians('$longitude') ) + sin( radians('$latitude') ) * sin( radians(latitude) ) ) ) <= $distance")
                        ->get();

                }

                $type = 0;
                foreach ($Providers as $key => $provider) {
                    (new SendPushNotification)->sendPushToProvider($provider->id, $Push->message, $type);
                }

            } elseif ($Push->send_to == 'ALL') {
                $type = 0;

                $Users = User::all();
                foreach ($Users as $key => $user) {
                    (new SendPushNotification)->sendPushToUser($user->id, $Push->message, $type);
                }

                $Providers = Provider::all();
                foreach ($Providers as $key => $provider) {
                    (new SendPushNotification)->sendPushToProvider($provider->id, $Push->message, $type);
                }

            }
        } catch (Exception $e) {
            return back()->with('flash_error', 'Something Went Wrong!');
        }
    }

    public function transactions(Request $request)
    {

        try {
            if($request->has('from_date') and $request->has('to_date')) {
                $wallet_transation = AdminWallet::with('walletRequest.provider.service')
                ->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)])
                    ->orderBy('id', 'desc')
                    ->paginate(Setting::get('per_page', '10'));
                if ($request->has('taxiNo')){
                    $taxiNo = $request->get('taxiNo');
                    $wallet_transation = AdminWallet::with('walletRequest.provider.service')
                        ->whereHas('walletRequest.provider.service' , function ($query) use($taxiNo){
                            $query->where('service_number',$taxiNo);
                    })
                        ->whereBetween('created_at', [Carbon::createFromFormat('Y-m-d', $request->from_date), Carbon::createFromFormat('Y-m-d', $request->to_date)])
                        ->orderBy('id', 'desc')
                        ->paginate(Setting::get('per_page', '10'));
                }
            }else{
                $wallet_transation = AdminWallet::with('walletRequest.provider.service')->orderBy('id', 'desc')
                    ->paginate(Setting::get('per_page', '10'));
            }


            $pagination = (new Helper)->formatPagination($wallet_transation);

            $wallet_balance = AdminWallet::sum('amount');
            $params = $request->all();
            return view('admin.wallet.wallet_transation', compact('wallet_transation', 'pagination', 'wallet_balance' , 'params'));

        } catch (Exception $e) {
            return back()->with('flash_error', $e->getMessage());
        }
    }

    public function transferlist(Request $request)
    {

        $croute = Route::currentRouteName();

        if ($croute == 'admin.fleettransfer') {
            $type = 'fleet';
        } else {
            $type = 'provider';
        }

        $pendinglist = WalletRequests::where('request_from', $type)->where('status', 0);
        if ($croute == 'admin.fleettransfer') {
            $pendinglist = $pendinglist->with('fleet');
        } else {
            $pendinglist = $pendinglist->with('provider');
        }

        $pendinglist = $pendinglist->get();

        return view('admin.wallet.transfer', compact('pendinglist', 'type'));
    }

    public function approve(Request $request, $id)
    {

        if ($request->send_by == "online") {
            $response = (new PaymentController)->send_money($request, $id);
        } else {
            (new TripController)->settlements($id);
            $response['success'] = 'Amount successfully send';
        }

        if (!empty($response['error'])) {
            $result['flash_error'] = $response['error'];
        }

        if (!empty($response['success'])) {
            $result['flash_success'] = $response['success'];
        }

        return redirect()->back()->with($result);

    }

    public function requestcancel(Request $request)
    {

        $cancel = (new TripController())->requestcancel($request);
        $response = json_decode($cancel->getContent(), true);

        if (!empty($response['error'])) {
            $result['flash_error'] = $response['error'];
        }

        if (!empty($response['success'])) {
            $result['flash_success'] = $response['success'];
        }

        return redirect()->back()->with($result);
    }

    public function transfercreate(Request $request, $id)
    {
        $type = $id;
        return view('admin.wallet.create', compact('type'));
    }

    public function search(Request $request)
    {

        $results = array();

        $term = $request->input('stext');
        $sflag = $request->input('sflag');

        if ($sflag == 1) {
            $providerService = ProviderService::where('service_number' , 'LIKE' , $term . '%')->get();
//            $providerIds = Provider::whereIn('id',$providerService->pluck('provider_id')->toArray());
            $queries = Provider::whereIn('id',$providerService->pluck('provider_id')->unique()->toArray())->get();
        } else {
            $queries = Fleet::where('name', 'LIKE', $term . '%')->take(5)->get();
        }

        foreach ($queries as $query) {
            $query->cabNumber = $term;
            $results[] = $query;
        }

        return response()->json(array('success' => true, 'data' => $results));

    }

    public function transferstore(Request $request)
    {

        try {
            if ($request->stype == 1) {
                $type = 'provider';
            } else {
                $type = 'fleet';
            }

            $nextid = Helper::generate_request_id($type);

            $amountRequest = new WalletRequests;
            $amountRequest->alias_id = $nextid;
            $amountRequest->request_from = $type;
            $amountRequest->from_id = $request->from_id;
            $amountRequest->type = $request->type;
            $amountRequest->send_by = $request->by;
            $amountRequest->amount = $request->amount;

            $amountRequest->save();

            //create the settlement transactions
            (new TripController)->settlements($amountRequest->id);

            return back()->with('flash_success', 'Settlement processed successfully');

        } catch (Exception $e) {
            return back()->with('flash_error', $e->getMessage());
        }
    }

    public function download(Request $request, $id)
    {

        $documents = ProviderDocument::where('provider_id', $id)->get();

        if (!empty($documents->toArray())) {

            $Provider = Provider::findOrFail($id);

            // Define Dir Folder
            $public_dir = public_path();

            // Zip File Name
            $zipFileName = $Provider->first_name . '.zip';

            // Create ZipArchive Obj
            $zip = new ZipArchive;

            if ($zip->open($public_dir . '/storage/' . $zipFileName, ZipArchive::CREATE) === true) {
                // Add File in ZipArchive
                foreach ($documents as $file) {
                    $zip->addFile($public_dir . '/storage/' . $file->url);
                }

                // Close ZipArchive
                $zip->close();
            }
            // Set Header
            $headers = array(
                'Content-Type' => 'application/octet-stream',
            );

            $filetopath = $public_dir . '/storage/' . $zipFileName;

            // Create Download Response
            if (file_exists($filetopath)) {
                return response()->download($filetopath, $zipFileName, $headers)->deleteFileAfterSend(true);
            }

            return redirect()
                ->route('admin.provider.document.index', $id)
                ->with('flash_success', 'documents downloaded successfully.');
        }

        return redirect()
            ->route('admin.provider.document.index', $id)
            ->with('flash_error', 'failed to downloaded documents.');

    }

    public function globalSearch(Request $request)
    {
        $search = $request->has('search') ? $request['search'] : null;
        if ($search) {
            $provider = Provider::whereHas('service', function ($query) use ($search) {
                $query->where('service_number', $search);
            })->first();
            if ($provider) {
                return redirect("admin/provider/$provider->id/statement");
            }
        }
        return redirect()->back()->with('flash_error', 'No driver found against your searched Taxi No.');
    }
}
